# -*- coding: utf-8 -*-
"""r08.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1OUAVpxfYL3-YgknJ8y0R0o71JEEcw0il
"""

import numpy as np
import matplotlib.pyplot as plt

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Odwrotność macierzy"""

A = np.array([ [1,4],[2,7] ])

Ainv = np.linalg.inv(A)

A@Ainv

fig,axs = plt.subplots(1,3,figsize=(10,6))


axs[0].imshow(A,cmap='gray')
axs[0].set_title('Macierz')
for (j,i),num in np.ndenumerate(A):
  axs[0].text(i,j,num,color=[.8,.8,.8],ha='center',va='center',fontsize=28)

axs[1].imshow(Ainv,cmap='gray')
axs[1].set_title('Odwrotność')
for (j,i),num in np.ndenumerate(Ainv):
  axs[1].text(i,j,num,color=[.8,.8,.8],ha='center',va='center',fontsize=28)

AAi = A@Ainv
axs[2].imshow(AAi,cmap='gray')
axs[2].set_title('Iloczyn')
for (j,i),num in np.ndenumerate(AAi):
  axs[2].text(i,j,num,color=[.8,.8,.8],ha='center',va='center',fontsize=28)


for i in range(3):
  axs[i].set_xticks([])
  axs[i].set_yticks([])

plt.tight_layout()
plt.savefig('rys8.1.png',dpi=300)
plt.show()



print( A@Ainv ), print(' ')
print( Ainv@A )

A*Ainv

A = np.array([ [1,4],[2,8] ])

Ainv = np.linalg.inv(A)

A@Ainv



"""# Odwrotność macierzy diagonalnej"""

D = np.diag( np.arange(1,6) )
Dinv = np.linalg.inv(D)

print('Macierz diagonalna:')
print(D), print(' ')

print('Jej odwrotność:')
print(Dinv), print(' ')

print('Ich iloczyn:')
print(D@Dinv)



"""# Odwrotność lewostronna"""

T = np.random.randint(-10,11,size=(40,4))

print( f'Rząd tej macierzy to={np.linalg.matrix_rank(T)}\n\n' )

TtT = T.T@T

TtT_inv = np.linalg.inv(TtT)
print( np.round(TtT_inv@TtT,4) )

L = TtT_inv @ T.T

print( np.round( L@T,6 ) ), print(' ')

print( np.round( T@L,6 ) )

fig,axs = plt.subplots(2,2,figsize=(10,10))

axs[0,0].imshow(T,cmap='gray')
axs[0,0].set_title('Wysoka macierz')

axs[0,1].imshow(L,cmap='gray')
axs[0,1].set_title('Odwrotność lewostronna')

axs[1,0].imshow(L@T,cmap='gray')
axs[1,0].set_title('L@T')

axs[1,1].imshow(T@L,cmap='gray')
axs[1,1].set_title('T@L')

for a in axs.flatten():
  a.set_xticks([])
  a.set_yticks([])

plt.tight_layout()
plt.savefig('rys8.4.png',dpi=300)
plt.show()





"""# Pseudoodwrotność Moore'a-Penrose'a"""

A = np.array([ [1,4],[2,8] ])

Apinv = np.linalg.pinv(A)
print(Apinv*85), print(' ')

A@Apinv

# przykład z liczbami losowymi
A = np.random.randn(7,5) @ np.random.randn(5,7)
print(f'Rząd tej macierzy to {np.linalg.matrix_rank(A)}.\n')

Apinv = np.linalg.pinv(A)
plt.imshow(A@Apinv)
plt.title('Macierz razy jej pseudoodwrotność')
plt.colorbar()
plt.show()



"""# Ćwiczenie 1."""

n = 5

# macierz
A = np.random.randn(n,n)

# jej odwrotność oraz odwrotność jej odwrotności
Ai  = np.linalg.inv(A)
Aii = np.linalg.inv(Ai)

# sprawdzam, czy ta druga równa się oryginalnej macierzy (z pewną tolerancją)
np.round( A-Aii ,10)



"""# Ćwiczenie 2."""

# tworzę macierz
m = 4
A = np.random.randn(m,m)

# inicjalizacja
M = np.zeros((m,m)) # macierz minorów
G = np.zeros((m,m)) # siatka

# obliczam minory
for i in range(m):
  for j in range(m):

    # wybieram wiersze i kolumny
    rows = [True]*m
    rows[i] = False

    cols = [True]*m
    cols[j] = False

    # obliczam wyznacznik
    M[i,j]=np.linalg.det(A[rows,:][:,cols])

    # wyznaczam siatkę
    G[i,j] = (-1)**(i+j)


# obliczam macierz dopełnień
C = M * G

# obliczam macierz dołączoną
Ainv = C.T / np.linalg.det(A)

# używam „zwykłej” funkcji do odwracania macierzy
AinvI = np.linalg.inv(A)

# porównuję mój wynik z wynikiem z inv()
np.round( AinvI-Ainv ,8)

# tworzę wykres

fig,axs = plt.subplots(2,3,figsize=(14,7))

axs[0,0].imshow(M,cmap='gray')
axs[0,0].set_title('Macierz minorów')

axs[0,1].imshow(G,cmap='gray')
axs[0,1].set_title('Siatka')

axs[0,2].imshow(C,cmap='gray')
axs[0,2].set_title('Macierz dopełnień algebraicznych')

axs[1,0].imshow(Ainv,cmap='gray')
axs[1,0].set_title('Macierz dołączona (odwrotność)')

axs[1,1].imshow(AinvI,cmap='gray')
axs[1,1].set_title('np.linalg.inv')

axs[1,2].imshow(A@Ainv,cmap='gray')
axs[1,2].set_title('A@Ainv')

for a in axs.flatten():
  a.set_xticks([])
  a.set_yticks([])


plt.savefig('rys8.3.png',dpi=300)
plt.show()



"""# Ćwiczenie 4."""

# szeroka macierz
W = np.random.randint(-10,11,size=(4,40))

# sprawdzam, czy macierz ta ma pełny rząd
print( f'Rząd tej macierzy to={np.linalg.matrix_rank(T)}\n\n' )

# tworzę macierz kwadratową o pełnym rzędzie
WWt = W@W.T

# sprawdzam czy macierz ta ma odwrotność
WWt_inv = np.linalg.inv(WWt)
print( np.round(WWt_inv@WWt,4) )

# kończę tworzenie odwrotności prawostronnej

# odwrotność prawostronna
R = W.T @ WWt_inv

# upewniam się czy działa
print( np.round( W@R,6 ) ), print(' ')

# i czy działa tylko z jednej strony
print( np.round( R@W,6 ) )

# wizualizacja

fig,axs = plt.subplots(2,2,figsize=(10,10))

axs[0,0].imshow(W,cmap='gray')
axs[0,0].set_title('Szeroka macierz')

axs[0,1].imshow(R,cmap='gray')
axs[0,1].set_title('Odwrotność prawostronna')

axs[1,0].imshow(R@W,cmap='gray')
axs[1,0].set_title('R@W')

axs[1,1].imshow(W@R,cmap='gray')
axs[1,1].set_title('W@R')

for a in axs.flatten():
  a.set_xticks([])
  a.set_yticks([])

plt.tight_layout()
plt.show()



"""# Ćwiczenie 5."""

# pełna odwrotność
M = 4

A = np.random.randn(M,M)

Ainv  = np.linalg.inv(A)
Apinv = np.linalg.pinv(A)

np.round( Ainv-Apinv,10 )

# odwrotność lewostronna
M,N = 14,4

A = np.random.randn(M,N)

ALeft = np.linalg.inv(A.T@A) @ A.T
Apinv = np.linalg.pinv(A)

np.round( ALeft-Apinv,10 )

# odwrotność prawostronna
M,N = 4,14

A = np.random.randn(M,N)

ARight = A.T @ np.linalg.inv(A@A.T)
Apinv  = np.linalg.pinv(A)

np.round( ARight-Apinv,10 )



"""# Ćwiczenie 6."""

# tworzę macierze
N = 4
A = np.random.randn(N,N)
B = np.random.randn(N,N)

# obliczam trzy określone w zadaniu iloczyny
op1 = np.linalg.inv(A@B)
op2 = np.linalg.inv(A) @ np.linalg.inv(B)
op3 = np.linalg.inv(B) @ np.linalg.inv(A)

# obliczam odległości
dist12 = np.sqrt(np.sum( (op1-op2)**2 ))
dist13 = np.sqrt(np.sum( (op1-op3)**2 ))

# wyświetlam wyniki!
print(f'Odległość pomiędzy (AB)^-1 i (A^-1)(B^-1) to {dist12:.8f}')
print(f'Odległość pomiędzy (AB)^-1 i (B^-1)(A^-1) to {dist13:.8f}')



"""# Ćwiczenie 7."""

# tworzę macierze
M,N = 14,4
T = np.random.randn(M,N)

# obliczam wartości
op1 = np.linalg.inv(T.T@T)
op2 = np.linalg.inv(T) @ np.linalg.inv(T.T)

# Odpowiedź brzmi nie, ponieważ wysoka macierz nie ma odwrotności.



"""# Ćwiczenie 8."""

# macierz przekształcenia
T = np.array([
              [1,.5],
              [0,.5]
            ])

# obliczam jej odwrotność
Ti = np.linalg.inv(T)


# definiuję zbiór punktów (z okręgu)
theta = np.linspace(0,2*np.pi-2*np.pi/20,20)
origPoints = np.vstack( (np.cos(theta),np.sin(theta)) )

# stosuję przekształcenie
transformedPoints = T @ origPoints

# cofam przekształcenie za pomocą macierzy odwrotnej
backTransformed   = Ti @ transformedPoints


# wykreślam wyniki
plt.figure(figsize=(8,8))
plt.plot(origPoints[0,:],origPoints[1,:],'ko',label='Punkty')
plt.plot(transformedPoints[0,:],transformedPoints[1,:],'s',
         color=[.7,.7,.7],label='Po przekształceniu')
plt.plot(backTransformed[0,:],backTransformed[1,:],'rx',markersize=15,
         color=[.7,.7,.7],label='Po zastosowaniu\nmacierzy odwrotnej')

plt.axis('square')
plt.xlim([-2,2])
plt.ylim([-2,2])
plt.legend()
plt.savefig('rys8.6.png',dpi=300)
plt.show()



"""# Ćwiczenie 9."""

# funkcja tworząca macierz Hilberta
def hilbmat(k):
  H = np.zeros((k,k))
  for i in range(k):
    for j in range(k):

      # uwaga: w formule matematycznej w mianowniku jest i+j-1
      #   czemu w przypadku indeksowania od zera odpowiada (i+1)+(j+1)-1
      #   a to można uprościć do postaci i+j+1

      H[i,j] = 1 / (i+j+1)
  return H



# powyższa implementacja to bezpośrednia realizacja formuły matematycznej
# funkcja poniżej zwraca ten sam wynik, ale nie korzysta z pętli
def hilbmat(k):
  k = np.arange(1,k+1).reshape(1,-1) # zamiana na wektor wierszowy
  return 1 / (k.T+k-1) # iloczyn zewnętrzny i dzielenie po elementach

print( hilbmat(5) ), print(' ')

# porównanie dokładności z funkcją wbudowaną w Pythona:
from scipy.linalg import hilbert
print( hilbert(5) )

# tworzę macierz Hilberta o wymiarach 5x5 i wyświetlam ją wraz z odwrotnością oraz iloczynem macierzy i jej odwrotności
H = hilbmat(5)
Hi = np.linalg.inv(H)

fig,axs = plt.subplots(1,3,figsize=(12,6))
h = [0,0,0]

# macierz
h[0] = axs[0].imshow(H,cmap='gray')
axs[0].set_title('Macierz Hilberta')

# odwrotność
h[1] = axs[1].imshow(Hi,cmap='gray')
axs[1].set_title('Odwrotność')

# ich iloczyn
h[2] = axs[2].imshow(H@Hi,cmap='gray')
axs[2].set_title('Iloczyn')


for i in range(2):
  fig.colorbar(h[i],ax=axs[i],fraction=.045)
  axs[i].set_xticks([])
  axs[i].set_yticks([])

plt.tight_layout()
plt.savefig('rys8.5.png',dpi=300)
plt.show()



"""# Ćwiczenie 10."""

matSizes = np.arange(3,13)

identityError = np.zeros((len(matSizes),2))
condNumbers   = np.zeros((len(matSizes),2))


for i,k in enumerate(matSizes):

    ### macierz Hilberta
    H   = hilbmat(k)       # macierz
    Hi  = np.linalg.inv(H) # jej odwrotność
    HHi = H@Hi             # powinna to być macierz jednostkowa
    err = HHi - np.eye(k)  # różnica w stosunku do macierzy jednostkowej
    identityError[i,0] = np.sqrt(np.sum(err**2))  # odległość euklidesowa
    condNumbers[i,0] = np.linalg.cond(H) # współczynnik uwarunkowania


    ### macierz wartości losowych
    H = np.random.randn(k,k) # macierz
    Hi  = np.linalg.inv(H)   # jej odwrotność
    HHi = H@Hi               # powinna to być macierz jednostkowa
    err = HHi - np.eye(k)    # różnica w stosunku do macierzy jednostkowej
    identityError[i,1] = np.sqrt(np.sum(err**2))  # odległość euklidesowa
    condNumbers[i,1] = np.linalg.cond(H) # współczynnik uwarunkowania



# rysowanie wykresu
fig,axs = plt.subplots(1,2,figsize=(14,5))

## odległość wyniku od macierzy jednostkowej
h = axs[0].plot(matSizes,np.log(identityError),'s-',markersize=12)
h[0].set_color('k')
h[0].set_marker('o')
h[1].set_color('gray')

axs[0].legend(['Macierz Hilberta','Macierz wartości losowych'])
axs[0].set_xlabel('Rozmiar macierzy')
axs[0].set_ylabel('Logarytm z odległości euklidesowej')
axs[0].set_title('Odległość od macierzy jednostkowej')



## wykres współczynnika uwarunkowania
h = axs[1].plot(matSizes,np.log(condNumbers),'s-',markersize=12)
h[0].set_color('k')
h[0].set_marker('o')
h[1].set_color('gray')

axs[1].legend(['Macierz Hilberta','Macierz wartości losowych'])
axs[1].set_xlabel('Rozmiar macierzy')
axs[1].set_ylabel('Logarytm z współczynnika uwarunkowania')
axs[1].set_title('Współczynnik uwarunkowania macierzy')

plt.savefig('rys8.7.png',dpi=300)
plt.show()

## sprawdzenie co kryje się w macierzy „jednostkowej”
H   = hilbmat(k)
Hi  = np.linalg.inv(H)
HHi = H@Hi

plt.imshow(HHi,vmin=0,vmax=.1)
plt.title('Powinna to być macierz jednostkowa')
plt.colorbar();

